<?
  /**
   * Javascript validator for "isURL" check
   * Perform the validation of "isURL" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)                         
   * @return string JS function body
   **/ 		
   function js_validator_isURL(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = $formcat->addFocus($field,$focus);
    	if(!empty($field)){
	   		$title = "\n\n// checks if ".$field." is URL string\n";
	   		$body = "var objRegExp = /^(((https?)|(ftp)):\/\/([\-\w]+\.)+\w{2,3}(\/[%\-\w]+(\.\w{2,})?)*(([\w\-\.\?\\/+@&#;`~=%!]*)(\.\w{2,})?)*\/?)/\n";
	   		$body.=($optional)?"if ((!objRegExp.test(fc['".$field."'].value)) && !confirm('$message')){\n":"if (!objRegExp.test(fc['".$field."'].value)){\nalert('$message');\n";
	   		      
	        $str= $title.$body.$focusStr."return false;\n}\n";		    
	        return $str;
	    }
    }

?>