<?
/**
 * Project: Formcat, the Smarty based forms client-side validator 
 * File:    pcFormcat.class.php
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For questions, help, comments, discussion, etc.,please contact
 * joey@justto.com
 * 
 * The latest version of Formcat can be obtained from:
 * http://www.propagator.net/formcat/
 *
 * @link http://www.propagator.net/formcat/
 * @copyright 2004,2005 Joey
 * @author Joey <joey@justto.com or joey@163.com> [msn: gzjoey@hotmail.com]
 **/
class formcat{

	var $formList;                                                   //cat form list
	var $validationList;                                             //validation list
	var $extraFuncList = array();                                    //extra functions list
	var $frmExtraFunc = array();                                     //form extra function
	var $curExtraFunc;                                               //current extra function list
	var $defaultErrMsg = "%s is invalid,Please check again";         //default alert message for all validators
	var $defaultSubmitOnceMsg = "Submitting,Please keep waiting";    //"Submit Once" extra function alert message
	var $flashFocus;                                                 //Boolean,whether flash input box when error occured
	var $submitOnce;                                                 //Boolean,disable submit button after press submit button
	var $extraFunc;                                                  //Extra functions 
	var $flashColor = "#FFFFFF";                                     //Flash Color 1
	var $flashColor2 = "#DC0C11";                                    //Flash Color 2
	var $keepFlashColor = 1;                                         //Boolean,whether keep flash color after flashed.(1-TRUE,0-FALSE)
	var $customJs = array();                                         //Customize Javascript list
	var $version = "1.0.4 Pro";                                     //Current version (DO NOT CHANGE)
	var $validatorPath = "../class/Smarty/libs/validators/";        //Validators path (pro version only)	
	
  /**
   * Constructor for the class
   * sets the data source, initializes the data container
   * @param string $form formname which in validation
   **/	
   function formcat(){
		 
		$this->formList = &$_SESSION['catformList'];	   
	}


  /**
   * formcat output fitler
   * Performs the generation of Javascript and replace the source of smarty output
   * 
   * @param string $source Source being filtered
   * @param Smarty $smarty Smarty object filtering the content
   * @return string filtered source 
   **/	
	function fcOutputFilter($source,&$smarty){
		if(count($this->formList)>0){
			$this->genJsCode();
			
			$replace = "<script language=Javascript type=text/javascript>".
			          "\n//------------------------------------------------------------------------------------------//\n".
			           "//This javascript is generated by FORMCAT Validator ".$this->version."(from PIGCAT FRAMEWORK)\n".
			           "//Author: Joey Wong [Huang Jun Yan] (MSN:gzjoey@hotmail.com)\n".
			           "//Special Thanks: Charlotte Chan		          \n".
			           "//Website: http://www.propagator.net/formcat/         \n".
			           "//2005 COPYRIGHT BY JUSTTO INC. DO NOT REMOVE THIS LICENSE NOTES!\n".
			           "//-------------------------------------------------------------------------------------------//\n".
	  					$this->jsStr.
			           "</script>\n";	  
			
			//place the javascript to html		                    
			if(preg_match('/<(form|FORM|Form)[^>]*>/',$source, $regs)){
				$formTags = $regs[0];
				$source = str_replace($formTags,$replace.$formTags,$source);
			}
			
			
		}
		return $source;
	}
	
  /**
   * Javascript function header generator
   * generate the Javascript function header
   * 
   * @return string JS function header
   **/	
	function genJsFuncHeader($formName){
		$str = "function pigcatFCValidate_".$formName."(fc){\n";
		$str.= "nameForm=fc; \n";
		
		return $str;
	}
	
  /**
   * Javascript function footer generator
   * generate the Javascript function footer
   * 
   * @return string JS function footer
   **/	
	function genJsFuncFooter(){
		$str = "\n\n}\n\n";
	    return $str;
	}
	
  /**
   * Get extra functions 
   * get the extra function which parsed by parseExtraFunc method
   * 
   * @return string JS extra function
   **/		
	function getJsFuncExtra(){	
		if(is_array($this->extraFuncList)){
			foreach($this->extraFuncList as $k=>$v){
				$extraFunc = "extra_function_".$v;
				$this->extraFunc.= $this->$extraFunc();
			}
		}		
		return $this->extraFunc;		
	}


  /**
   * Add Extra Function to extra function list
   * 
   * @return string Javascript focus string 
   **/	 
   function addExtraFunc($funcName){
   		if($funcName!=''&& $funcName!='form' && $funcName!='FORM' && $funcName!='Form'){
   			if(!in_array($funcName,$this->extraFuncList)){
   				$this->extraFuncList = array_merge($this->extraFuncList,$funcName);
   			}
   		}
   }
   
   
  /**
   * Add Javascript focus string and flash focus string.
   * 
   * @return string Javascript focus string 
   **/	 
	function addFocus($field,$focus=TRUE) {
    	$str = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
    	if($this->frmExtraFunc['flashFocus']) $str.="flashing(fc.name, '$field',0,10,0);\n";                          //Flash focus function 
    	return $str;
	} 	
   
   
  /**
   * Parse extra functions by extra function list
   * @return void
   **/	   
   function parseExtraFunc($formName){
    	
    	$curFuncList = &$_SESSION['catformParams_'.$formName];               //extra function list of each catform
    	unset($this->frmExtraFunc);
    	//process extra function
    	if(is_array($curFuncList)){
    		foreach($curFuncList as $k=>$v){
    			$this->frmExtraFunc[$k] = ($v==TRUE)?TRUE:FALSE;    			
    			$this->addExtraFunc($k);
    		
    			//Add extra function calls
    			
    			//*add Submit Once Function 
		       if($this->frmExtraFunc['submitOnce']) $this->addCustomJs($formName, "\n submitOnce($formName);\n");
    		}
    	}
    	
    }
    	    	  

  /**
   * Javascript function body generator
   * generate the Javascript function body
   * 
   * @return string JS function body
   **/	
	function genJsCode(){
		
		foreach($this->formList as $formKey=>$formName){
			
			$validationList = &$_SESSION['catform_'.$formName];                    //validate list of each catfrom
			if(empty($validationList)) break;
			$this->parseExtraFunc($formName);                                      //process catform extra function
	
			//generate the validation javascript
		    foreach($validationList as $fcKey=>$fcValidation){
		    	$validator = "js_validator_".$fcValidation['check'];
				//include the validator php
				$validatorFile = $this->validatorPath.$validator.".php";
				if(file_exists($validatorFile)){
					
					require_once $validatorFile;
					
				}		    	
				// check if the function is defined in the included file
		    	if (!function_exists($validator)) {
              		trigger_error("[FORMCAT WARNING]Validation function $validator not found in $validatorFile");
            	
            	}else{
		    		
		    		$genStr = $validator($this,array_change_key_case($fcValidation));
		    		$jsStr.=$genStr;
		    	}
		    }
		    		    		    
		    $this->jsStr.= $this->genJsFuncHeader($formName).$jsStr;
		   
		    if($this->customJs[$formName]!='')  $this->jsStr.= $this->customJs[$formName];
		   
		    $this->jsStr.= $this->genJsFuncFooter();
			
			//clear the session and js string for next round
			session_unregister('catform_'.$formName);
			session_unregister('catform_extra_'.$formName);
			$jsStr = '';
		}
		session_unregister('catformList'); //clear the cat form list
		$this->jsStr.= $this->getJsFuncExtra();
	}


  /**
   * Add customized javascript to the validating function
   * 
   * @return void
   **/	
    function addCustomJs($formName,$jsStr){
    	$this->customJs[$formName] = "\n//Custom JS \n".$jsStr;
     
    }
    
//////////// extra function for catform  ///////////
/**
 * Javascript submit once function generator
 * generate the Javascript submit once function 
 * 
 * @return string JS function 
 *
 **/	
	function extra_function_submitOnce(){
	 	
		 //generate javascript
		 $str="\n //Submit Once Function (author: Joey)\n
		 function submitOnce(theform) {
		 if (document.all || document.getElementById) {
			for (i = 0; i < theform.length; i++) {
			var tempobj = theform.elements[i];
			if (tempobj.type.toLowerCase() == 'submit' || tempobj.type.toLowerCase() == 'reset')
				tempobj.disabled = true;
			}
			setTimeout('alert(\"$this->defaultSubmitOnceMsg\")', 1500);
			return true;
			}
			else {
			alert('$this->defaultSubmitOnceMsg');
			return false;
			  }
		}
		";
		return $str;
	}
	
/**
 * Javascript flashing function generator
 * generate the Javascript flashing function 
 * 
 * @return string JS function header
 * @Author: Sylvestre Ledru (thanks for his contribution) ***
**/	
	function extra_function_flashFocus($flashColor="",$flashColor2="",$keepColor=""){
		
		//define flash color set 
		$flashColor = (empty($flashColor))?$this->flashColor:$flashColor;
		$flashColor2 = (empty($flashColor2))?$this->flashColor2:$flashColor2;
		$keepColor = (empty($keepColor))?$this->keepFlashColor:$keepColor;
		
		//generate javascript
		$str="\n //Flash Focus Function (author: Sylvestre Ledru)\n
	 	 tpsFlashing=100;
		 function setColorError(nameForm,name,colorError)
		 {
		 	setColorBG(nameForm, name, colorError)
		 }
		 
		 function setColorBG(nameForm, name, color)
		 {
		 	form=getForm(nameForm);
		 	eval(form+'.'+name+'.style.background=\"'+color+'\"')
		 }
		 
		 function flashing(nameForm,name,c,nbre,indexC)
		 {
		 	form=getForm(nameForm);
		 	eval(form+'.'+name+'.style.background=('+c+')?\"'+colorFlashing2+'\":\"'+colorFlashing+'\"');
		 	c=1-c
		 	indexC++
		 
		 	if(indexC>nbre)
		 	{
		 		if(keepColor) setColorError(nameForm,name,colorFlashing2)
		 		return
		 	}
		 	setTimeout(\"flashing('\"+nameForm+\"', '\"+name+\"',\"+c+\",\"+nbre+\",\"+indexC+\")\",tpsFlashing)
		 }
		 
		 function getForm(nameForm) {
		 	var ns4=(document.layers)? true:false;
		 	var ns6=(document.getElementById)? true:false;
		 	var ie4=(document.all)? true:false;
		 	if (ns4) {
		 		
		 		return 'document.layers['+nameForm+']';
		 	}
		 	if (ie4) {
		 		return 'document.'+nameForm;
		 	}
		 	//	alert(nameForm);
		 	return 'document.getElementById(\"'+nameForm+'\")';
		 
		 }
		 
		 keepColor=$keepColor;
		 colorFlashing=\"$flashColor\"
		 colorFlashing2=\"$flashColor2\"\n
		 ";
 		return $str;
   }

}
?>