<?php

/**
 * AuriumForm Smarty Integration
 *
 * usage:
 * {auriumform type='type' attributes..}
 *
 * - If called before {auriumform_config ...}
 * all the fields will have the config no_template=true
 * - If called after {auriumform_config ...}
 * all the fields will use the given template
 *
 * Especial Cases:
 * TEXTAREA - in place of using size=array(COLS, ROWS), use cols=X rows=Y, e.g.:
 * {auriumform type='textarea' cols=10 rows=10}
 *
 * TEXT, PASSWORD and TEXTAREA
 * - Set attribute strip=true if you want to stripslashes of the value
 * - htmlentities will be called for the values of this type of fields
 *
 * - Use the attribute n as an alias for no_template
 *
 * @since Feb 17, 2005
 * @author Alfred Reinold Baudisch <alfred@auriumsoft.com.br>
 */
function smarty_function_auriumform($params, &$smarty)
{
    /**
     * There is no AuriumForm class created yet, then import it
     */
    if(!class_exists('AuriumForm'))
    {
        require_once 'auriumform/class.auriumform.php';
        $smarty->_AuriumForm =& new AuriumForm(array('no_template' => true));
    }

    // Initiate field array
    $Field = array();
 
    /**
     * If is textarea, create an array for the size with the attributes cols and rows
     */
    if($params['type'] == 'textarea' && isset($params['cols']) && isset($params['rows']))
    {
        $Field['size'] = array($params['cols'], $params['rows']);

        // To not go through this data again
        unset($params['cols']);
        unset($params['rows']);
    }

    /**
     * Set field attributes
     */
    foreach($params as $_key => $_val)
    {
        /**
         * If attribute is value, do special things
         */
        if($_key == 'value')
        {
            /**
             * If is to stripslashes from data, e.g.: data obtained from BD
             */
            if($params['strip'])
            {
                $_val = stripslashes($_val);
            }

            /**
             * If is a box or something like this, escape characters like
             * ' " & to the html respective entity to avoid things like:
             * <input type="text" value="My name is "">
             * In the example, the value is My name is ", but it will be shown wrong,
             * there is a unexpected ", so htmlentities will transtale "
             * in &quot; and the value will be show correctly
             */
            if(eregi('^(text|textarea|password)$', $params['type']))
            {
                $_val = htmlentities($_val, ENT_QUOTES);
            }
        }
        // If is 'no' (alias for 'no_template'), set it to no_template
        elseif($_key == 'no')
        {
            $_key = 'no_template';
        }
        
        // Send data to field array
        $Field[$_key] = $_val;
    }
    
    // Create and return the field    
    return $smarty->_AuriumForm->OneField($Field);
}

?>