<?php

/**
 * AuriumForm Smarty Integration
 *
 * Function: To create AuriumForm class and set the template for the fields and
 * others configurations
 *
 * usage:
 * {auriumform_config open='' label='' field='' error='' close='' line='' field_one=''}
 * optional: css, size and css_error
 *
 * Use |LABEL|, |FIELD| and |ERROR| in the appropiate template places.
 * See more on AuriumForm class file.
 *
 * You can call this function in the same file how many times you need.
 *
 * @since Feb 17, 2005
 * @author Alfred Reinold Baudisch <alfred@auriumsoft.com.br>
 */
function smarty_function_auriumform_config($params, &$smarty)
{
    if(!class_exists('AuriumForm'))
    {
        require_once 'auriumform/class.auriumform.php';
    }
    
    /**
     * Set class attributes
     */
    $Config = array();

    if($params['css'] && is_object($smarty->_AuriumForm))
    {
        $smarty->_AuriumForm->SetConfig(array('css' => $params['css']));
    }
    elseif($params['css'])
    {
        $Config['css'] = $params['css'];
    }

    if($params['css_error'] && is_object($smarty->_AuriumForm))
    {
        $smarty->_AuriumForm->SetConfig(array('css_error' => $params['css_error']));
    }
    elseif($params['css_error'])
    {
        $Config['css_error'] = $params['css_error'];
    }

    if($params['size'] && is_object($smarty->_AuriumForm))
    {
        $smarty->_AuriumForm->SetConfig(array('size' => $params['size']));
        
    }
    elseif($params['size'])
    {
        $Config['size'] = $params['size'];
    }

    if(!is_object($smarty->_AuriumForm))
    {
        $smarty->_AuriumForm =& new AuriumForm($Config);
    }    
    
    /**
     * Set class template
     */
    $Template = array();

    foreach($params as $_key => $_val)
    {
        $Template['template_' . $_key] = $_val;
    }

    if(sizeof($Template))
    {
        $smarty->_AuriumForm->SetTemplate($Template);
    }
}

?>