<?
  /**
   * Javascript validator for "radioChecked" check
   * Perform the validation of "radioChecked"(Check box is checked)check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_radioChecked(&$formcat,$params){
   		extract($params);
   		$fieldMark = str_replace(array('[',']'),'',$field);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		if(!empty($field)){
	   		 $str = "\n\n// checks if ".$field." is checked\n\n";
	   		 $str.= "var ".$fieldMark."_checked = false;\n" .
	   		 "var count = 0;\n".
	   		 "count = fc['$field'].length;\n".
	   		 "if(count>0){\n".
	      	 "for (var i = 0, count ; i < count; i++) {\n" .
	         "if (fc['$field'][i].checked) {\n" .
	          "    ".$fieldMark."_checked = true;\n" .
	         " }\n" .
	         "}\n".
	         "}else{\n".
	         "if (fc['$field'].checked) {\n" .
	          "    ".$fieldMark."_checked = true;\n" .
	         " }\n" .	         
	         "}\n";
	       
	        $str.=($optional)?"if (!".$fieldMark."_checked && !confirm('$message')) {\n":"if (!".$fieldMark."_checked) {\nalert('$message');\n";
	              
	        $str.= "return false;\n}\n\n";
	        return $str;
	   }
    }
?>