<?  
  /**
   * Javascript validator for "isRegExp" check
   * Perform the validation of "isRegExp" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field       Field to test
   *						   string   $expression  regular expression
   *                           bool     $reverse     reverse operation 
   *                           bool     $focus       If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 	

  function js_validator_isRegExp(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = $formcat->addFocus($field,$focus);
   		if($reverse!='') $reverse = true;
   		if($field!='' && $expression!=''){
   			$title = "\n//check the field by regex\n";
   			$body = "var myregexp = new RegExp(\"".$expression."\");\n".
   			        "var match = myregexp.exec(fc['".$field."'].value);\n";
   		
   			if($reverse) $body.=($optional)?"if(match==null && !confirm('$message')){\n":"if(match==null){\nalert('$message');\n";
   				else  $body.=($optional)?"if(match!=null && !confirm('$message')){\n":"if(match!=null){\nalert('$message');\n";
	        	  	   		         
	   	   $str= $title.$body.$focusStr."return false;\n}\n";			       
	       return $str;
		}
   	}	    
 ?>