<?
  /**
   * Javascript validator for "cboxChecked" check
   * Perform the validation of "cboxChecked"(Check box is checked)check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_cboxChecked(&$formcat,$params){
   		extract($params);
   		$fieldMark = str_replace(array('[',']'),'',$field);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
		if(!empty($field)){
	   		 $title = "\n\n// checks if ".$field." is checked\n\n";
	   		 $body = "var ".$fieldMark."_checked = false;\n" .
	        "var count   = fc['$field'].length;\n" .
	        "if(count){\n" .
	        "  for (var i = 0; i < count; i++) {\n" .
	        "    if (fc['$field'][i].checked) {\n" .
	         "    ".$fieldMark."_checked = true;\n" .
	        "    }\n" .
	        "  }\n" .
	        "} else {\n" .
	        "  if (fc['$field'].checked) {\n" .
	        "    ".$fieldMark."_checked = true;\n" .
	        "  }\n" .
	        "}\n" .
	        "\n";
	        
	        if($optional){
	        	$body.="if ((!".$fieldMark."_checked) && !confirm('$message')){\nreturn false;\n}\n\n";
	        }else{
	        	$body.="if (!".$fieldMark."_checked) {\nalert('$message');\nreturn false;\n}\n\n";
	        }
	        
	        $str = $title.$body;
	        return $str;
	   }
    }
?>