<?  
  /**
   * Javascript validator for "isRestrict" check
   * Perform the validation of "isRestrict" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field     Field to test
   *						   string   $restrict  restrict letter 
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 	
   function js_validator_isRestrict(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = $formcat->addFocus($field,$focus);
   		if(strtolower($restrict)=='notab') $restrict = "\\t\\n\\r";
   		if(strtolower($restrict)=='specialchars') $restrict = "><,[]{}?/+=|\\\'\\\":;~!@#*$%^&()`";
   		if($field!='' && $restrict!=''){
   			$title = "\n //check restrict letter\n";
   			$body = "var badChar = \"".$restrict."\";\n".
	        	    "var i;\n".
	        	    "for (i = 0; i < fc['".$field."'].value.length; i++){\n".
	        	    "var c = fc['".$field."'].value.charAt(i);\n";
	       	$body.=($optional)?"if (badChar.indexOf(c)>=0 && !confirm('$message')) {\n":"if (badChar.indexOf(c)>=0) {\nalert('$message');\n";
	   		      
	        $str= $title.$body.$focusStr."return false;\n}}\n";		
	        return $str;
	    }
    }	
?>    