<?
  /**
   * Javascript validator for "dateCompare" check
   * Perform the validation of "dateCompare" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $after_year  $after_month  $after_day  after date
   *						   string   $before_year $before_month $before_day before date
   *                           boolean  $dateEqual   if set TRUE,then if the "after_date" must be the  same as the "before_date"
   *                           boolean  $compToday if set TRUE,then it will ignore the "before_date" replace with TODAY
   * @return string JS function body
   **/ 	
   function js_validator_dateCompare(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if($after_year!='' && $after_month!='' && $after_day!='' && $before_year!='' && $before_month!='' && $before_day!='') {
	   		$str = "\n\n //compare two input dates.\n";
	       	$str.= "var date1 = fc['".$after_year."'].value+'/'+fc['".$after_month."'].value+'/'+fc['".$after_day."'].value;\n".
	       	       "var date2 = fc['".$before_year."'].value+'/'+fc['".$before_month."'].value+'/'+fc['".$before_day."'].value;\n".
	       	       "var d1 = new Date(date1);\n";
	       	//if "compToday" set TRUE,then it will ignore the "before_date" replace with TODAY       
	       	if($compToday!='') $str.= "var d2 = new Date();\n";
	       		else $str.= "var d2 = new Date(date2);\n";
	       	
	       	 $str.= "if(d1=='NaN' || d2=='NaN'){\n".
	       	 		 "alert('$message');\nreturn false;\n".
	       	 		 "}\n".
	       	        "var difference = d1.getTime() - d2.getTime();\n".
	       	        "var elapsedDays = difference/1000/60/60/24;\n";
	       	        
	       	//if "dateEqual" set TRUE,then if the "after_date" must be the  same as the "before_date"       
			if($dateEqual!='') $str.= "if(elapsedDays!=0){\n";
				else $str.= "if(elapsedDays<0){\n";
	       	             		  
			$str.= "alert('$message');\n".
					"return false;\n".
			        "}\n";  	
	   	    
	        return $str;
	    }
    }
?>