<?php

/**
 * AuriumForm Smarty Integration
 * Opens a form with the given attributes
 *
 * Especial Cases:
 * - METHOD: you can use the alias 'm' for method and
 * 'p' for POST and 'g' for GET
 * E.g.: {auriumform_open m=p}
 *
 * - ACTION: you can use the alias 'a' for 'action'
 * E.g.: {auriumform_open a='bla.php'}
 *
 * @since Feb 17, 2005
 * @author Alfred Reinold Baudisch <alfred@auriumsoft.com.br>
 */
function smarty_function_auriumform_open($params, &$smarty)
{
    /**
     * There is no AuriumForm class created yet, then import it
     */
    if(!class_exists('AuriumForm'))
    {
        require_once 'auriumform/class.auriumform.php';
        $smarty->_AuriumForm =& new AuriumForm(array('no_template' => true));
    }
    
    return $smarty->_AuriumForm->OpenForm($params);
}

?>