<?

function chart_VBar($ar_chart) {
	include "class/chart/libchart/classes/libchart.php";
	$param					= get_param("CHART");
	$tmp_folder				= $param[TMPDIR];
	$ar_data				= $ar_chart[data];
	$f_output				= $tmp_folder . $ar_chart[fname];
	$key_total				= $ar_chart[key_total];
	$key_label				= $ar_chart[key_label];
	$chart 					= new VerticalBarChart($ar_chart[w], $ar_chart[h]);
	$dataSet 				= new XYDataSet();
	for ($i=0; $i<count($ar_data); $i++) {
		$dataSet->addPoint(new Point($ar_data[$i][$key_label], $ar_data[$i][$key_total]));
		//echo $ar_data[$i][$key_label] . ", " .  $ar_data[$i][$key_total] . "<br>";
	}	
	$chart->setDataSet($dataSet);
	$chart->setTitle($ar_chart[title]);
	$chart->render($f_output);
	return $f_output;
}

function chart_HBar($ar_chart) {  
	include "class/chart/libchart/classes/libchart.php";
	$param					= get_param("CHART");
	$tmp_folder				= $param[TMPDIR];
	$ar_data				= $ar_chart[data];
	$f_output				= $tmp_folder . $ar_chart[fname];
	if (file_exists($f_output)) { unlink($f_output); }
	$chart 					= new HorizontalBarChart($ar_chart[w], $ar_chart[h]);
	$dataSet 				= new XYDataSet();
	switch ($ar_chart[rpt]) {
		case 'leader_weekly_report':
			for ($i=count($ar_data);$i>=0; $i--) {
				$dataSet->addPoint(new Point($ar_data[$i][nama_leader], $ar_data[$i][api_submit]));
			}
			break;
		case 'agent_weekly_report':
			for ($i=count($ar_data)-1;$i>=0; $i--) {
				$dataSet->addPoint(new Point($ar_data[$i][nama_agen] , $ar_data[$i][api_submit]));
			}
			break;
		case 'level_weekly_report':
			for ($i=count($ar_data);$i>=0; $i--) {
				$dataSet->addPoint(new Point($ar_data[$i][nama_agen], $ar_data[$i][api_submit]));
			}
			break;
		case 'unit_report':
			for ($i=count($ar_data);$i>=0; $i--) {
				$dataSet->addPoint(new Point($ar_data[$i][nama_agen], $ar_data[$i][ytd_api_submit]));
			}
			break;
		case 'summary_leader':
			for ($i=count($ar_data);$i>=0; $i--) {
				$dataSet->addPoint(new Point($ar_data[$i][nama_unit], $ar_data[$i][api_submit]));
			}
			break;
	}
	
	$chart->setDataSet($dataSet);
	$chart->getPlot()->setGraphPadding(new Padding(5, 30, 20, 140));
	$chart->setTitle($ar_chart[title]);
	$chart->render($f_output);
	
	return $f_output;
}

function pie_chart($ar_chart) {

	include "class/chart/libchart/classes/libchart.php";
	$param					= get_param("CHART");
	$tmp_folder				= $param[TMPDIR];
	$ar_data				= $ar_chart[data];
	$f_output				= $tmp_folder . $ar_chart[fname];
	$chart 					= new PieChart($ar_chart[w], $ar_chart[h]);
	$key_total				= $ar_chart[key_total];
	$key_label				= $ar_chart[key_label];
	$dataSet = new XYDataSet();

	for ($i=0; $i<count($ar_data); $i++) {
		$dataSet->addPoint(new Point($ar_data[$i][$key_label], $ar_data[$i][$key_total]));
	}
	$chart->setDataSet($dataSet);
	$chart->setTitle($ar_chart[title]);
	$chart->render($f_output);
	
	return $f_output;
}



function pie_browser_platform($ar_chart) {

	include "class/chart/libchart/classes/libchart.php";
	$param					= get_param("CHART");
	$tmp_folder				= $param[TMPDIR];
	$ar_data				= $ar_chart[data];
	$f_output				= $tmp_folder . $ar_chart[fname];
	$chart 					= new PieChart($ar_chart[w], $ar_chart[h]);
	$dataSet = new XYDataSet();

	for ($i=0; $i<count($ar_data); $i++) {
		$dataSet->addPoint(new Point($ar_data[$i][platform], $ar_data[$i][ncount]));
	}
	$chart->setDataSet($dataSet);
	$chart->setTitle($ar_chart[title]);
	$chart->render($f_output);
	
	return $f_output;
}

function pie_browser_size($ar_chart) {

	include "class/chart/libchart/classes/libchart.php";
	$param					= get_param("CHART");
	$tmp_folder				= $param[TMPDIR];
	$ar_data				= $ar_chart[data];
	$f_output				= $tmp_folder . $ar_chart[fname];
	$chart 					= new PieChart($ar_chart[w], $ar_chart[h]);
	$dataSet = new XYDataSet();

	for ($i=0; $i<count($ar_data); $i++) {
		$dataSet->addPoint(new Point($ar_data[$i][screen], $ar_data[$i][ncount]));
	}
	$chart->setDataSet($dataSet);
	$chart->setTitle($ar_chart[title]);
	$chart->render($f_output);
	
	return $f_output;
}



?>