SELECT 	r.rtlid as 'c_rtlid|#|95|left|Title-14|', 
		lower(r.rtlnm) AS 'c_rtlnm|Retail|375|left|Title-14|', 
		sum(n_qtyIN) as 'n_qtyout|QtyIN|80|center|Title-14|',
        sum(n_qtyOUT) as 'n_qtyout|QtyOUT|80|center|Title-14|',
        SUM((n_qtyIN + n_qtyOUT)) as 'n_rmn|Remain|80|center|Title-14|'
FROM
(
    (SELECT v.rtlid, 
			0 AS n_qtyIN,
			sum(-1 * v.rtl_qty) AS n_qtyOUT
			FROM t_dsrhd i 	left join t_dsrdt v ON (i.vchno=v.vchno) 
			where 	i.spaid='$spaid'
					and i.vchdt>='$tgl1'
					and i.vchdt<='$tgl2'
					and v.rtlid <>''
				group by v.rtlid
				ORDER BY v.rtlid
     )
UNION ALL
     (SELECT v.rtlid, 
                sum(i.source * v.rtl_qty) AS n_qtyIN,
                0 AS n_qtyOUT
                FROM t_invhd i 	left join t_invdt v ON (i.vchno=v.vchno) 
                where 	i.spaid='$spaid'
						and v.rtlid=v.rtlid <>''
                    	and i.vchdt>='$tgl1'
						and i.vchdt<='$tgl2'
            GROUP BY v.rtlid
            ORDER BY v.rtlid
     )
)
derivedTable  LEFT JOIN m_rtl r ON (r.rtlid=derivedTable.rtlid)
WHERE derivedTable.rtlid <>''
GROUP BY derivedTable.rtlid
ORDER BY derivedTable.rtlid