/*!
* TableSorter 2.2.2 - Client-side table sorting with ease!
* Minified using http://dean.edwards.name/packer/
* Copyright (c) 2007 Christian Bach
*/
!(function($){$.extend({tablesorter:new function(){this.version="2.2.2";var q=[],widgets=[],tbl;this.defaults={cssHeader:"tablesorter-header",cssAsc:"tablesorter-headerSortUp",cssDesc:"tablesorter-headerSortDown",cssChildRow:"expand-child",cssInfoBlock:"tablesorter-infoOnly",sortInitialOrder:"asc",sortMultiSortKey:"shiftKey",sortForce:null,sortAppend:null,sortLocaleCompare:false,sortReset:false,sortRestart:false,emptyTo:"bottom",stringTo:"max",textExtraction:"simple",textSorter:null,ignoreCase:true,parsers:{},widgets:[],headers:{},empties:{},strings:{},widthFixed:false,cancelSelection:true,sortList:[],headerList:[],dateFormat:"mmddyyyy",usNumberFormat:true,onRenderHeader:null,selectorHeaders:'thead th',selectorRemove:"tr.remove-me",tableClass:'tablesorter',debug:false,widgetOptions:{zebra:["even","odd"]}};function log(s){if(typeof console!=="undefined"&&typeof console.log!=="undefined"){console.log(s)}else{alert(s)}}function benchmark(s,d){log(s+" ("+(new Date().getTime()-d.getTime())+"ms)")}this.benchmark=benchmark;this.hasInitialized=false;function getElementText(a,b,c){var d="",te=a.textExtraction;if(!b){return""}if(!a.supportsTextContent){a.supportsTextContent=b.textContent||false}if(te==="simple"){if(a.supportsTextContent){d=b.textContent}else{if(b.childNodes[0]&&b.childNodes[0].hasChildNodes()){d=b.childNodes[0].innerHTML}else{d=b.innerHTML}}}else{if(typeof(te)==="function"){d=te(b,tbl[0],c)}else if(typeof(te)==="object"&&te.hasOwnProperty(c)){d=te[c](b,tbl[0],c)}else{d=$(b).text()}}return d}function getParserById(a){var i,l=q.length;for(i=0;i<l;i++){if(q[i].id.toLowerCase()===(a.toString()).toLowerCase()){return q[i]}}return false}function trimAndGetNodeText(a,b,c){return $.trim(getElementText(a,b,c))}function detectParserForColumn(a,b,c,d){var i,l=q.length,node=false,nodeValue='',keepLooking=true;while(nodeValue===''&&keepLooking){c++;if(b[c]){node=b[c].cells[d];nodeValue=trimAndGetNodeText(a.config,node,d);if(a.config.debug){log('Checking if value was empty on row '+c+', column:'+d+": "+nodeValue)}}else{keepLooking=false}}for(i=1;i<l;i++){if(q[i].is(nodeValue,a,node)){return q[i]}}return q[0]}function getData(m,a,b,c){var d='';if(m&&m[c]){d=m[c]}else if(a&&a[c]){d=a[c]}else if(b&&b.match(c+'-')){d=b.match(new RegExp(c+'-(\\w+)'))[1]||''}return $.trim(d)}function buildParserCache(a,b){if(a.tBodies.length===0){return}var c=a.config,rows=a.tBodies[0].rows,list,l,i,h,m,ch,cl,p,parsersDebug="";if(rows[0]){list=[];l=rows[0].cells.length;for(i=0;i<l;i++){h=$(b[i]);m=$.metadata?h.metadata():false;ch=c.headers[i];cl=h.attr('class')||'';p=getParserById(getData(m,ch,cl,'sorter'));c.empties[i]=getData(m,ch,cl,'empty')||c.emptyTo||(c.emptyToBottom?'bottom':'top');c.strings[i]=getData(m,ch,cl,'string')||c.stringTo||'max';if(!p){p=detectParserForColumn(a,rows,-1,i)}if(c.debug){parsersDebug+="column:"+i+"; parser:"+p.id+"; string:"+c.strings[i]+'; empty: '+c.empties[i]+"\n"}list.push(p)}}if(c.debug){log(parsersDebug)}return list}function buildRegex(){var a,acc='[',t=$.tablesorter,reg=t.characterEquivalents;t.characterRegexArray={};for(a in reg){if(typeof a==='string'){acc+=reg[a];t.characterRegexArray[a]=new RegExp('['+reg[a]+']','g')}}t.characterRegex=new RegExp(acc+']')}function buildCache(a){var b=a.tBodies,tc=a.config,totalRows,totalCells,q=tc.parsers,t,i,j,k,c,cols,cacheTime;tc.cache={};if(tc.debug){cacheTime=new Date()}for(k=0;k<b.length;k++){tc.cache[k]={row:[],normalized:[]};if(!$(b[k]).hasClass(tc.cssInfoBlock)){totalRows=(b[k]&&b[k].rows.length)||0;totalCells=(b[k].rows[0]&&b[k].rows[0].cells.length)||0;for(i=0;i<totalRows;++i){c=$(b[k].rows[i]);cols=[];if(c.hasClass(tc.cssChildRow)){tc.cache[k].row[tc.cache[k].row.length-1]=tc.cache[k].row[tc.cache[k].row.length-1].add(c);continue}tc.cache[k].row.push(c);for(j=0;j<totalCells;++j){t=trimAndGetNodeText(tc,c[0].cells[j],j);cols.push(q[j].format(t,a,c[0].cells[j],j))}cols.push(tc.cache[k].normalized.length);tc.cache[k].normalized.push(cols)}}}if(tc.debug){benchmark("Building cache for "+totalRows+" rows",cacheTime)}}function getWidgetById(a){var i,w,l=widgets.length;for(i=0;i<l;i++){w=widgets[i];if(w&&w.hasOwnProperty('id')&&w.id.toLowerCase()===a.toLowerCase()){return w}}}function applyWidget(a,b){var c=a.config.widgets,i,w,l=c.length;for(i=0;i<l;i++){w=getWidgetById(c[i]);if(w){if(b&&w.hasOwnProperty('init')){w.init(a,widgets,w)}else if(!b&&w.hasOwnProperty('format')){w.format(a)}}}}function appendToTable(a){var c=a.config,b=a.tBodies,rows=[],r,n,totalRows,checkCell,f,i,j,k,l,pos,appendTime;if(c.debug){appendTime=new Date()}for(k=0;k<b.length;k++){if(!$(b[k]).hasClass(c.cssInfoBlock)){f=document.createDocumentFragment();r=c.cache[k].row;n=c.cache[k].normalized;totalRows=n.length;checkCell=totalRows?(n[0].length-1):0;for(i=0;i<totalRows;i++){pos=n[i][checkCell];rows.push(r[pos]);if(!c.appender||!c.removeRows){l=r[pos].length;for(j=0;j<l;j++){f.appendChild(r[pos][j])}}}a.tBodies[k].appendChild(f)}}if(c.appender){c.appender(a,rows)}if(c.debug){benchmark("Rebuilt table",appendTime)}applyWidget(a);$(a).trigger("sortEnd",a)}function computeTableHeaderCellIndexes(t){var a=[],lookup={},thead=t.getElementsByTagName('THEAD')[0],trs=thead.getElementsByTagName('TR'),i,j,k,l,c,cells,rowIndex,cellId,rowSpan,colSpan,firstAvailCol,matrixrow;for(i=0;i<trs.length;i++){cells=trs[i].cells;for(j=0;j<cells.length;j++){c=cells[j];rowIndex=c.parentNode.rowIndex;cellId=rowIndex+"-"+c.cellIndex;rowSpan=c.rowSpan||1;colSpan=c.colSpan||1;if(typeof(a[rowIndex])==="undefined"){a[rowIndex]=[]}for(k=0;k<a[rowIndex].length+1;k++){if(typeof(a[rowIndex][k])==="undefined"){firstAvailCol=k;break}}lookup[cellId]=firstAvailCol;for(k=rowIndex;k<rowIndex+rowSpan;k++){if(typeof(a[k])==="undefined"){a[k]=[]}matrixrow=a[k];for(l=firstAvailCol;l<firstAvailCol+colSpan;l++){matrixrow[l]="x"}}}}return lookup}function formatSortingOrder(v){return(/^d/i.test(v)||v===1)}function checkHeaderMetadata(a){return(($.metadata)&&($(a).metadata().sorter===false))}function checkHeaderOptions(a,i){return((a.config.headers[i])&&(a.config.headers[i].sorter===false))}function checkHeaderLocked(a,i){if((a.config.headers[i])&&(a.config.headers[i].lockedOrder!==null)){return a.config.headers[i].lockedOrder}return false}function checkHeaderOrder(a,i){if((a.config.headers[i])&&(a.config.headers[i].sortInitialOrder)){return a.config.headers[i].sortInitialOrder}return a.config.sortInitialOrder}function buildHeaders(b){var d=($.metadata)?true:false,header_index=computeTableHeaderCellIndexes(b),$th,lock,time,$tableHeaders,c=b.config;c.headerList=[];if(c.debug){time=new Date()}$tableHeaders=$(c.selectorHeaders,b).wrapInner("<div class='tablesorter-header-inner' />").each(function(a){this.column=header_index[this.parentNode.rowIndex+"-"+this.cellIndex];this.order=formatSortingOrder(checkHeaderOrder(b,a))?[1,0,2]:[0,1,2];this.count=-1;if(checkHeaderMetadata(this)||checkHeaderOptions(b,a)||$(this).hasClass('sorter-false')){this.sortDisabled=true}this.lockedOrder=false;lock=checkHeaderLocked(b,a);if(typeof(lock)!=='undefined'&&lock!==false){this.order=this.lockedOrder=formatSortingOrder(lock)?[1,1,1]:[0,0,0]}if(!this.sortDisabled){$th=$(this).addClass(c.cssHeader);if(c.onRenderHeader){c.onRenderHeader.apply($th,[a])}}c.headerList[a]=this;$(this).parent().addClass(c.cssHeader)});if(c.debug){benchmark("Built headers",time);log($tableHeaders)}return $tableHeaders}function isValueInArray(v,a){var i,l=a.length;for(i=0;i<l;i++){if(a[i][0]===v){return true}}return false}function setHeadersCss(a,b,c){var h=[],i,l,css=[a.config.cssDesc,a.config.cssAsc];b.removeClass(css[0]).removeClass(css[1]);b.each(function(){if(!this.sortDisabled){h[this.column]=$(this)}});l=c.length;for(i=0;i<l;i++){if(c[i][1]===2){continue}h[c[i][0]].addClass(css[c[i][1]])}}function fixColumnWidth(a){if(a.config.widthFixed){var b=$('<colgroup>');$("tr:first td",a.tBodies[0]).each(function(){b.append($('<col>').css('width',$(this).width()))});$(a).prepend(b)}}function updateHeaderSortCount(a,b){var i,s,o,c=a.config,l=b.length;for(i=0;i<l;i++){s=b[i];o=c.headerList[s[0]];o.count=s[1]%(c.sortReset?3:2)}}function getCachedSortType(a,i){return(a)?a[i].type:''}function multisort(a,b){var d,col,mx=0,dir=0,tc=a.config,l=b.length,bl=a.tBodies.length,sortTime,i,j,k,c,cache,lc,s,e,order,orgOrderCol;if(tc.debug){sortTime=new Date()}for(k=0;k<bl;k++){d="var sortWrapper = function(a,b) {";cache=tc.cache[k];lc=cache.normalized.length;for(i=0;i<l;i++){c=b[i][0];order=b[i][1];s=getCachedSortType(tc.parsers,c)==="text"?"Text":"Numeric";s+=order===0?"":"Desc";e="e"+i;if(/Numeric/.test(s)&&tc.strings[c]){for(j=0;j<lc;j++){col=Math.abs(parseFloat(cache.normalized[j][c]));mx=Math.max(mx,isNaN(col)?0:col)}if(typeof(tc.string[tc.strings[c]])==='boolean'){dir=(order===0?1:-1)*(tc.string[tc.strings[c]]?-1:1)}else{dir=(tc.strings[c])?tc.string[tc.strings[c]]||0:0}}d+="var "+e+" = sort"+s+"(a["+c+"],b["+c+"],"+c+","+mx+","+dir+"); ";d+="if ("+e+") { return "+e+"; } ";d+="else { "}orgOrderCol=(cache.normalized&&cache.normalized[0])?cache.normalized[0].length-1:0;d+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(i=0;i<l;i++){d+="}; "}d+="return 0; ";d+="}; ";eval(d);cache.normalized.sort(sortWrapper)}if(tc.debug){benchmark("Sorting on "+b.toString()+" and dir "+order+" time",sortTime)}}function sortText(a,b,d){if(a===b){return 0}var c=tbl[0].config,e=c.string[(c.empties[d]||c.emptyTo)],r=$.tablesorter.regex,xN,xD,yN,yD,xF,yF,i,mx;if(a===''&&e!==0){return(typeof(e)==='boolean')?(e?-1:1):-e||-1}if(b===''&&e!==0){return(typeof(e)==='boolean')?(e?1:-1):e||1}if(typeof c.textSorter==='function'){return c.textSorter(a,b)}xN=a.replace(r[0],'\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0');yN=b.replace(r[0],'\0$1\0').replace(/\0$/,'').replace(/^\0/,'').split('\0');xD=parseInt(a.match(r[2]))||(xN.length!==1&&a.match(r[1])&&Date.parse(a));yD=parseInt(b.match(r[2]))||(xD&&b.match(r[1])&&Date.parse(b))||null;if(yD){if(xD<yD){return-1}if(xD>yD){return 1}}mx=Math.max(xN.length,yN.length);for(i=0;i<mx;i++){xF=(!(xN[i]||'').match(r[3])&&parseFloat(xN[i]))||xN[i]||0;yF=(!(yN[i]||'').match(r[3])&&parseFloat(yN[i]))||yN[i]||0;if(isNaN(xF)!==isNaN(yF)){return(isNaN(xF))?1:-1}if(typeof xF!==typeof yF){xF+='';yF+=''}if(xF<yF){return-1}if(xF>yF){return 1}}return 0}function sortTextDesc(a,b,d){if(a===b){return 0}var c=tbl[0].config,e=c.string[(c.empties[d]||c.emptyTo)];if(a===''&&e!==0){return(typeof(e)==='boolean')?(e?-1:1):e||1}if(b===''&&e!==0){return(typeof(e)==='boolean')?(e?1:-1):-e||-1}if(typeof c.textSorter==='function'){return c.textSorter(b,a)}return sortText(b,a)}function getTextValue(a,b,d){if(b){var i,l=a.length,n=b+d;for(i=0;i<l;i++){n+=a.charCodeAt(i)}return d*n}return 0}function sortNumeric(a,b,f,g,d){if(a===b){return 0}var c=tbl[0].config,e=c.string[(c.empties[f]||c.emptyTo)];if(a===''&&e!==0){return(typeof(e)==='boolean')?(e?-1:1):-e||-1}if(b===''&&e!==0){return(typeof(e)==='boolean')?(e?1:-1):e||1}if(isNaN(a)){a=getTextValue(a,g,d)}if(isNaN(b)){b=getTextValue(b,g,d)}return a-b}function sortNumericDesc(a,b,f,g,d){if(a===b){return 0}var c=tbl[0].config,e=c.string[(c.empties[f]||c.emptyTo)];if(a===''&&e!==0){return(typeof(e)==='boolean')?(e?-1:1):e||1}if(b===''&&e!==0){return(typeof(e)==='boolean')?(e?1:-1):-e||-1}if(isNaN(a)){a=getTextValue(a,g,d)}if(isNaN(b)){b=getTextValue(b,g,d)}return b-a}this.construct=function(g){return this.each(function(){if(!this.tHead||this.tBodies.length===0){return}var f,$cell,totalRows,$this,config,c,i,j,k,a,s,o;this.config={};c=config=$.extend(true,this.config,$.tablesorter.defaults,g);tbl=$this=$(this).addClass(c.tableClass);$.data(this,"tablesorter",c);buildRegex();c.string={'max':1,'min':-1,'max+':1,'max-':-1,'zero':0,'none':0,'null':0,'top':true,'bottom':false};f=buildHeaders(this);c.parsers=buildParserCache(this,f);buildCache(this);fixColumnWidth(this);f.click(function(e){if(!this.sortDisabled){$this.trigger("sortStart",$this[0]);$cell=$(this);k=!e[c.sortMultiSortKey];this.count=(this.count+1)%(c.sortReset?3:2);if(c.sortRestart){i=this;f.each(function(){if(this!==i&&(k||!$(this).is('.'+c.cssDesc+',.'+c.cssAsc))){this.count=-1}})}i=this.column;if(k){c.sortList=[];if(c.sortForce!==null){a=c.sortForce;for(j=0;j<a.length;j++){if(a[j][0]!==i){c.sortList.push(a[j])}}}if(this.order[this.count]<2){c.sortList.push([i,this.order[this.count]])}}else{if(isValueInArray(i,c.sortList)){for(j=0;j<c.sortList.length;j++){s=c.sortList[j];o=c.headerList[s[0]];if(s[0]===i){s[1]=o.order[o.count];if(s[1]===2){c.sortList.splice(j,1);o.count=-1}}}}else{if(this.order[this.count]<2){c.sortList.push([i,this.order[this.count]])}}}if(c.sortAppend!==null){a=c.sortAppend;for(j=0;j<a.length;j++){if(a[j][0]!==i){c.sortList.push(a[j])}}}$this.trigger("sortBegin",$this[0]);setHeadersCss($this[0],f,c.sortList);appendToTable($this[0],multisort($this[0],c.sortList));return false}}).mousedown(function(){if(c.cancelSelection){this.onselectstart=function(){return false};return false}});$this.bind("update",function(e,a){$(c.selectorRemove,this).remove();c.parsers=buildParserCache(this,f);buildCache(this);if(a!==false){$this.trigger("sorton",[c.sortList])}}).bind("updateCell",function(e,a,b){var d=[(a.parentNode.rowIndex-1),a.cellIndex],tbodyindex=$this.find('tbody').index($(a).closest('tbody'));$this[0].config.cache[tbodyindex].normalized[d[0]][d[1]]=c.parsers[d[1]].format(getElementText(c,a,d[1]),$this[0],a,d[1]);if(b!==false){$this.trigger("sorton",[c.sortList])}}).bind("addRows",function(e,a,b){var i,rows=a.filter('tr').length,dat=[],l=a[0].cells.length,tbodyindex=$this.find('tbody').index(a.closest('tbody'));for(i=0;i<rows;i++){for(j=0;j<l;j++){dat[j]=c.parsers[j].format(getElementText(c,a[i].cells[j],j),$this[0],a[i].cells[j],j)}dat.push(c.cache[tbodyindex].row.length);c.cache[tbodyindex].row.push([a[i]]);c.cache[tbodyindex].normalized.push(dat);dat=[]}if(b!==false){$this.trigger("sorton",[c.sortList])}}).bind("sorton",function(e,a){$this.trigger("sortStart",$this[0]);c.sortList=a;var b=c.sortList;updateHeaderSortCount(this,b);setHeadersCss(this,f,b);appendToTable(this,multisort(this,b))}).bind("appendCache",function(){appendToTable(this)}).bind("applyWidgetId",function(e,a){getWidgetById(a).format(this)}).bind("applyWidgets",function(){applyWidget(this)});if($.metadata&&($(this).metadata()&&$(this).metadata().sortlist)){c.sortList=$(this).metadata().sortlist}applyWidget(this,true);if(c.sortList.length>0){$this.trigger("sorton",[c.sortList])}else{applyWidget(this)}this.hasInitialized=true;$this.trigger('tablesorter-initialized',this);if(typeof c.initialized==='function'){c.initialized(this)}})};this.addParser=function(b){var i,l=q.length,a=true;for(i=0;i<l;i++){if(q[i].id.toLowerCase()===b.id.toLowerCase()){a=false}}if(a){q.push(b)}};this.addWidget=function(a){widgets.push(a)};this.formatFloat=function(s){if(typeof(s)!=='string'){return s}if(tbl[0].config.usNumberFormat){s=s.replace(/,/g,'')}else{s=s.replace(/[\s|\.]/g,'').replace(/,/g,'.')}if(/^\s*\([.\d]+\)/.test(s)){s=s.replace(/^\s*\(/,'-').replace(/\)/,'')}var i=parseFloat(s);return isNaN(i)?$.trim(s):i};this.isDigit=function(s){return(/^[\-+(]?\d*[)]?$/).test($.trim(s.replace(/[,.'\s]/g,'')))};this.regex=[/(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|[0-9]+)/gi,/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,/^0x[0-9a-f]+$/i,/^0/];this.characterEquivalents={"a":"\u00e1\u00e0\u00e2\u00e3\u00e4","A":"\u00c1\u00c0\u00c2\u00c3\u00c4","c":"\u00e7","C":"\u00c7","e":"\u00e9\u00e8\u00ea\u00eb","E":"\u00c9\u00c8\u00ca\u00cb","i":"\u00ed\u00ec\u0130\u00ee\u00ef","I":"\u00cd\u00cc\u0130\u00ce\u00cf","o":"\u00f3\u00f2\u00f4\u00f5\u00f6","O":"\u00d3\u00d2\u00d4\u00d5\u00d6","S":"\u00df","u":"\u00fa\u00f9\u00fb\u00fc","U":"\u00da\u00d9\u00db\u00dc"};this.replaceAccents=function(s){if(this.characterRegex.test(s)){var a,eq=this.characterEquivalents;for(a in eq){if(typeof a==='string'){s=s.replace(this.characterRegexArray[a],a)}}}return s};this.clearTableBody=function(a){$(a.tBodies).filter(':not(.'+a.config.cssInfoBlock+')').empty()}}})();$.fn.extend({tablesorter:$.tablesorter.construct});var u=$.tablesorter;u.addParser({id:"text",is:function(s){return true},format:function(s,a){var c=a.config;s=$.trim(c.ignoreCase?s.toLocaleLowerCase():s);return c.sortLocaleCompare?$.tablesorter.replaceAccents(s):s},type:"text"});u.addParser({id:"digit",is:function(s){return $.tablesorter.isDigit(s)},format:function(s){return $.tablesorter.formatFloat(s.replace(/[^\w,. \-()]/g,""))},type:"numeric"});u.addParser({id:"currency",is:function(s){return(/^\(?[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]/).test(s)},format:function(s){return $.tablesorter.formatFloat(s.replace(/[^0-9,. \-()]/g,""))},type:"numeric"});u.addParser({id:"ipAddress",is:function(s){return(/^\d{2,3}[\.]\d{2,3}[\.]\d{2,3}[\.]\d{2,3}$/).test(s)},format:function(s){var i,item,a=s.split("."),r="",l=a.length;for(i=0;i<l;i++){item=a[i];if(item.length===2){r+="0"+item}else{r+=item}}return $.tablesorter.formatFloat(r)},type:"numeric"});u.addParser({id:"url",is:function(s){return(/^(https?|ftp|file):\/\/$/).test(s)},format:function(s){return $.trim(s.replace(/(https?|ftp|file):\/\//,''))},type:"text"});u.addParser({id:"isoDate",is:function(s){return(/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/).test(s)},format:function(s){return $.tablesorter.formatFloat((s!=="")?new Date(s.replace(/-/g,"/")).getTime():"")},type:"numeric"});u.addParser({id:"percent",is:function(s){return(/\%\)?$/).test($.trim(s))},format:function(s){return $.tablesorter.formatFloat(s.replace(/%/g,""))},type:"numeric"});u.addParser({id:"usLongDate",is:function(s){return s.match(/^[A-Za-z]{3,10}\.? [0-9]{1,2}, ([0-9]{4}|'?[0-9]{2}) (([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(AM|PM)))$/)},format:function(s){return $.tablesorter.formatFloat(new Date(s).getTime())},type:"numeric"});u.addParser({id:"shortDate",is:function(s){return(/\d{1,4}[\/\-\,\.\s+]\d{1,4}[\/\-\.\,\s+]\d{1,4}/).test(s)},format:function(s,a,b,d){var c=a.config,format=(c.headers&&c.headers[d])?c.headers[d].dateFormat||c.dateFormat:c.dateFormat;s=s.replace(/\s+/g," ").replace(/[\-|\.|\,]/g,"/");if(format==="mmddyyyy"){s=s.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$1/$2")}else if(format==="ddmmyyyy"){s=s.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$2/$1")}else if(format==="yyyymmdd"){s=s.replace(/(\d{4})[\/\s](\d{1,2})[\/\s](\d{1,2})/,"$1/$2/$3")}return $.tablesorter.formatFloat(new Date(s).getTime())},type:"numeric"});u.addParser({id:"time",is:function(s){return(/^(([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(am|pm)))$/).test(s)},format:function(s){return $.tablesorter.formatFloat(new Date("2000/01/01 "+s).getTime())},type:"numeric"});u.addParser({id:"metadata",is:function(s){return false},format:function(s,a,b){var c=a.config,p=(!c.parserMetadataName)?'sortValue':c.parserMetadataName;return $(b).metadata()[p]},type:"numeric"});u.addWidget({id:"zebra",format:function(a){var d,$r,row,even,time,k,c=a.config,child=c.cssChildRow,b=a.tBodies,css=["even","odd"];css=c.widgetZebra&&c.hasOwnProperty('css')?c.widgetZebra.css:(c.widgetOptions&&c.widgetOptions.hasOwnProperty('zebra'))?c.widgetOptions.zebra:css;if(a.config.debug){time=new Date()}for(k=0;k<b.length;k++){row=0;d=$(b[k]).filter(':not('+c.cssInfoBlock+')').find('tr:visible:not(.'+c.cssInfoBlock+')');if(d.length>1){d.each(function(){$r=$(this);if(!$r.hasClass(child)){row++}even=(row%2===0);$r.removeClass(css[even?1:0]).addClass(css[even?0:1])})}}if(a.config.debug){$.tablesorter.benchmark("Applying Zebra widget",time)}}})})(jQuery);
