<?
  /**
   * Javascript validator for "isEmail" check
   * Perform the validation of "isEmail" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isEmail(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = $formcat->addFocus($field,$focus);
  		if(!empty($field)){
	   		$title = "\n\n// checks if ".$field." is valid email address\n";
	   		$body = "var regu = \"^(([0-9a-zA-Z]+)|([0-9a-zA-Z]+[_.0-9a-zA-Z-]*[0-9a-zA-Z]+))@([a-zA-Z0-9-]+[.])+([a-zA-Z]{2}|net|NET|com|COM|gov|GOV|mil|MIL|org|ORG|edu|EDU|int|INT|biz|BIZ|info|INFO|name|NAME)$\";\n".
	   		        "var re = new RegExp(regu);\n";
	   		        
	   		$body.=($optional)?"if (fc['$field'].value.search(re) == -1 && !confirm('$message')) {\n":"if (fc['$field'].value.search(re) == -1) {\nalert('$message');\n";
	   		       
	       	$str= $title.$body.$focusStr."return false;\n}\n";		
	       	return $str;
	   }
    }
?>