<?
/**
 * Project: Formcat, form client-side validate class.
 * File:    formcat.class.php
 * 
 * (c) 2004-2005 Justto.com Propagator Team
 * Author: Joey Wong [joey@justto.com][MSN:gzjoey@hotmail.com]
 * Website: http://formcat.justto.com
 * Released under both BSD and GNU Lesser GPL library license. 
 * This means you can use it in proprietary products.
 *
 * For questions, help, comments, discussion, etc.,please contact
 * joey@justto.com
 * 
 * The latest version of Formcat can be obtained from:
 * http://formcat.justto.com/ or http://formcat.joey.cn
 *
 * @link http://formcat.justto.com/ or http://formcat.joey.cn
 * @copyright 2004,2005 Joey Wong.
 * @author Joey <joey@163.com> [msn:gzjoey@hotmail.com]
 **/
class formcat{


	var $validationList;                                               //validation list
	var $formList;                                                     //form list
	var $defaultErrMsg = "%s is invalid,Please check again";           //Default error message ,when message attribute is empty,it will be replacement.
	var $customJs = array();                                           //Customizing Javascript.
	var $validatorPath = "validators/";                                //Validators path (pro version only)
	var $version = "1.0.1 Lite";     
	
  /**
   * Constructor for the class
   * sets the data source, initializes the data container
   * @param string $form formname which in validation
   **/	
   function formcat(){
		$this->formList = &$_SESSION['catformList'];
		
	   
	}


  /**
   * formcat output fitler
   * Performs the generation of Javascript and replace the source of smarty output
   * 
   * @param string $source Source being filtered
   * @param Smarty $smarty Smarty object filtering the content
   * @return string filtered source 
   **/	
	function fcOutputFilter($source,&$smarty){
		
		$this->genJsCode();
		
		$replace = "<script language=Javascript type=text/javascript>".
		          "\n//--------------------------------------------------------------------------//\n".
		           "//This javascript is generated by PIGCAT FREAMWORK(FORMCAT PLUGIN ".$this->version.")\n".
		           "//Author: Joey@justto.com(MSN:gzjoey@hotmail.com)\n".
		           "//Special Thanks: Charlotte Chan		          \n".
		           "//2005 COPYRIGHT BY JUSTTO INC. DO NOT REMOVE THIS LICENSE NOTES!\n".
		           "//--------------------------------------------------------------------------//\n".
  					$this->jsStr.
		           "</script>\n";	  
		
		//place the javascript to html		                    
		if(preg_match('/<(form|FORM|Form)[^>]*>/',$source, $regs)){
			$formTags = $regs[0];
			$source = str_replace($formTags,$replace.$formTags,$source);
		}
		
		return $source;
	}
	
  /**
   * Javascript function header generator
   * generate the Javascript function header
   * 
   * @return string JS function header
   **/	
	function genJsFuncHeader($formName){
		$str = "function pigcatFCValidate_".$formName."(fc){\n";
		return $str;
	}
	
  /**
   * Javascript function footer generator
   * generate the Javascript function footer
   * 
   * @return string JS function footer
   **/	
	function genJsFuncFooter(){
		$str = "\n\n}\n\n";
	    return $str;
	}
	
  /**
   * Javascript function body generator
   * generate the Javascript function body
   * 
   * @return string JS function body
   **/	
	function genJsCode(){
	
		foreach($this->formList as $formKey=>$formName){
			
			$validationList = $_SESSION['catform_'.$formName];
	
			//generate the validation javascript
		    foreach($validationList as $fcKey=>$fcValidation){
		    	$validator = "js_validator_".$fcValidation['check'];
		    	$ret = $this->$validator(array_change_key_case($fcValidation));
		    	$jsStr.=$ret;
		    }
		    
		    $this->jsStr.= $this->genJsFuncHeader($formName).$jsStr;
		    if($this->customJs[$formName]!='')  $this->jsStr.= $this->customJs[$formName];
		   
		     $this->jsStr.= $this->genJsFuncFooter();
			
			//clear the session and js string for next round
			session_unregister('catform_'.$formName);
			$jsStr = '';
		}
		session_unregister('catformList'); //clear the cat form list
	}


  /**
   * Add customized javascript to the validating function
   * 
   * @return void
   **/	
    function addCustomJs($formName,$jsStr){
    	$this->customJs[$formName] = "\n//Custom JS \n".$jsStr;
     
    }



////////////  js validator ////////////////////
 	

  /**
   * Javascript validator for "notEmpty" check
   * Perform the validation of "notEmpty" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 	
 	function js_validator_notEmpty($params){
 	    extract($params);
 	    $message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
 	    $focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
 	    if(!empty($field)){
 	    	$str = "\n\n// checks if ".$field." has been filled\n\n".
 	        	   "if(fc['$field'].value==''){\nalert('$message');\n".
 	               $focusStr."return false;\n}\n";
 	    	return $str;
 	    }
	}
 
  /**
   * Javascript validator for "isRange" check
   * Perform the validation of "isRange" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   int      $min      Min value
   *                           int      $max      Max value    
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isRange($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		
   		$str = "\n\n //checks value whether in the setting range.\n";
       	if($min!="" && $max!=""){
       		$str.= "if(!(fc['".$field."'].value>=".$min." && fc['".$field."'].value<=".$max.")){\n".
		           "alert('$message');\n".
			       $focusStr."return false;\n".
			       "}\n";  	
			
			return $str;
		}
    }

  /**
   * Javascript validator for "isLength" check
   * Perform the validation of "isLength" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   int      $min      Min value
   *                           int      $max      Max value    
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isLength($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		
   		$str = "\n\n //checks input value's length whether in the setting length.\n";
       	if($min!="" && $max!=""){
       		$str.= "if(!(fc['".$field."'].value.length>=".$min." && fc['".$field."'].value.length<=".$max.")){\n".
		           "alert('$message');\n".
			       $focusStr."return false;\n".
			       "}\n";  	
			
			return $str;
		}
    }

 
  /**
   * Javascript validator for "cboxChecked" check
   * Perform the validation of "cboxChecked"(Check box is checked)check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_cboxChecked($params){
   		extract($params);
   		$fieldMark = str_replace(array('[',']'),'',$field);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
		if(!empty($field)){
	   		 $str = "\n\n// checks if ".$field." is checked\n\n";
	   		 $str.= "var ".$fieldMark."_checked = false;\n" .
	        "var count   = fc['$field'].length;\n" .
	        "if(count){\n" .
	        "  for (var i = 0; i < count; i++) {\n" .
	        "    if (fc['$field'][i].checked) {\n" .
	         "    ".$fieldMark."_checked = true;\n" .
	        "    }\n" .
	        "  }\n" .
	        "} else {\n" .
	        "  if (fc['$field'].checked) {\n" .
	        "    ".$fieldMark."_checked = true;\n" .
	        "  }\n" .
	        "}\n" .
	        "\n";
	        
	        $str.="if (!".$fieldMark."_checked) {\n" .
	    		   "alert('$message');\n" .
	               "return false;\n" .
	    		    "}\n\n";
	        
	        return $str;
	   }
    }
   		
  /**
   * Javascript validator for "radioChecked" check
   * Perform the validation of "radioChecked"(Check box is checked)check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_radioChecked($params){
   		extract($params);
   		$fieldMark = str_replace(array('[',']'),'',$field);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		if(!empty($field)){
	   		 $str = "\n\n// checks if ".$field." is checked\n\n";
	   		 $str.= "var ".$fieldMark."_checked = false;\n" .
	      	 "for (var i = 0, count = fc['$field'].length; i < count; i++) {\n" .
	         "if (fc['$field'][i].checked) {\n" .
	          "    ".$fieldMark."_checked = true;\n" .
	         " }\n" .
	         "}\n";
	  
	        
	        $str.="if (!".$fieldMark."_checked) {\n" .
	    		   "alert('$message');\n" .
	               "return false;\n" .
	    		    "}\n\n";
	        
	        return $str;
	   }
    }



  /**
   * Javascript validator for "isSelected" check
   * Perform the validation of "isSelected" check
 
   * @param array    $params   params set including following parameters:	
   *                           string          $field           Field to test
   *						   int             $index           Default Index
   * @return string JS function body
   **/ 		
   function js_validator_isSelected($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(empty($index)) $index = 0;
   		if(!empty($field)){
	   		$str = "\n\n //checks the listmenu whether selected .\n";
	       	$str.= "if(fc['".$field."'].selectedIndex <= ".$index."){\n".
					"alert('$message');\n".
				    $focusStr."return false;\n".
				    "}\n";  	
	   	    
	        return $str;
	    }
    }

  /**
   * Javascript validator for "isEmail" check
   * Perform the validation of "isEmail" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isEmail($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(!empty($field)){
	   		$str = "\n\n// checks if ".$field." is valid email address\n";
	   		$str.= "var regu = \"^(([0-9a-zA-Z]+)|([0-9a-zA-Z]+[_.0-9a-zA-Z-]*[0-9a-zA-Z]+))@([a-zA-Z0-9-]+[.])+([a-zA-Z]{2}|net|NET|com|COM|gov|GOV|mil|MIL|org|ORG|edu|EDU|int|INT)$\";\n".
	   		        "var re = new RegExp(regu);\n".
	   		        "if (fc['$field'].value.search(re) == -1) {\n".
	   		        "   alert('$message');\n".
	   		        $focusStr."   return false;\n".
	   		        "}\n\n";
	        
	       return $str;
	   }
    }

  /**
   * Javascript validator for "isInt" check
   * Perform the validation of "isInt" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isInt($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(!empty($field)){
	   		 $str = "\n\n// checks if ".$field." is interger\n";
	   		 $str.= "var validChar = '0123456789';\n".
	        	   "var i;\n".
	        	   "for (i = 0; i < fc['".$field."'].value.length; i++){\n".
	        	   "var c = fc['".$field."'].value.charAt(i);\n".
	        	   "if (validChar.indexOf(c) == -1) {\n".
	        	   "alert('$message');\n".
	   		       $focusStr."return false;\n".
	   		       "}\n}\n";
	        return $str;
	    }
    }

  /**
   * Javascript validator for "isFloat" check
   * Perform the validation of "isFloat" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isFloat($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(!empty($field)){
	   		$str = "\n\n// checks if ".$field." is interger\n";
	   		$str.= "var validChar = '0123456789.+-';\n".
	        	   "var i;\n".
	        	   "for (i = 0; i < fc['".$field."'].value.length; i++){\n".
	        	   "var c = fc['".$field."'].value.charAt(i);\n".
	        	   "if (validChar.indexOf(c) == -1) {\n".
	        	   "alert('$message');\n".
	   		       $focusStr."return false;\n".
	   		       "}\n}\n";
	        return $str;
	   }
    }
    
  /**
   * Javascript validator for "isDate" check
   * Perform the validation of "isDate" check
 
   * @param array    $params   params set including following parameters:	
   *                           int      $year     Year Field to test
   *                           int      $month    Month field to check
   *                           int      $day      Day field to check
   * @return string JS function body
   **/ 		
   function js_validator_isDate(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,"The inputed DATE"):$message;
   		if($year!='' && $month!='' && $day!=''){
	   		 $str = "\n\n// checks if ".$field." is date\n";
	   		 $str.= "var year = fc['".$year."'].value;\n".
	   		        "var month = fc['".$month."'].value;\n".
	   		        "var day = fc['".$day."'].value;\n".
	   		        "var tempDate = new Date(year,month,day);\n".
	   		        "var realyr = tempDate.getFullYear();\n".
	   		        "var realm = tempDate.getMonth();\n".
	   		        "var reald = tempDate.getDate();\n";
				   		        
	   		 $str.=($optional)?"if ((year!=realyr || month!=realm || day!=reald) && !confirm('$message')){\nreturn false;\n}\n":"if (year!=realyr || month!=realm || day!=reald){\nalert('$message');\nreturn false;\n}\n";
	   		        
	   		 return $str;
	   }
	}

  /**
   * Javascript validator for "isURL" check
   * Perform the validation of "isURL" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)                         
   * @return string JS function body
   **/ 		
   function js_validator_isURL($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(!empty($field)){
	   		$str = "\n\n// checks if ".$field." is URL string\n";
	   		$str.= "var objRegExp = /^(((https?)|(ftp)):\/\/([\-\w]+\.)+\w{2,3}(\/[%\-\w]+(\.\w{2,})?)*(([\w\-\.\?\\/+@&#;`~=%!]*)(\.\w{2,})?)*\/?)/\n".
	   		       "if (!objRegExp.test(fc['".$field."'].value)){\n".
	   		       "alert('$message');\n".
	   		        $focusStr."return false;\n".
	   		       "}\n";
	        return $str;
	    }
    }
 
  /**
   * Javascript validator for "isEqual" check
   * Perform the validation of "isEqual" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   string   $field2   Field2 to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isEqual($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field2.".focus();\n";
   		if($field!='' && $field2!=''){
	   		$str = "\n\n //checks if two fields are equal in value. field2 attribute required.\n";
	   		$str.= "if(fc['".$field."'].value != fc['".$field2."'].value){\n".
	   		       "alert('$message');\n".
	   		        $focusStr."return false;\n".
	   		       "}\n";   		       
	        return $str;
	    }
    }

  /**
   * Javascript validator for "isFileSize" check
   * Perform the validation of "isFileSize" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   string   $min      minimum size 
   *                           string   $max      maximum size 
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		

   function js_validator_isFileSize($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(!empty($field)){
	   		$str = "\n\n //checks file size.\n".
	   			   "var oas=new ActiveXObject(\"Scripting.FileSystemObject\");\n".
	   			   "var fname=fc['".$field."'].value;\n".
	   			   "var fh=oas.getFile(fname);\n".
	   			   "var fsize=fh.size/1024;\n"; 
	   			  			
	   		if(!empty($min)){
				$str.= "if(fsize>".$min."){\n".
				       "alert('$message');\n".
				       $focusStr."return false;\n".
				       "}\n";  
	   	    }
	   	    
	   		if(!empty($max)){
				$str.= "if(fsize<".$max."){\n".
				       "alert('$message');\n".
				       $focusStr."return false;\n".
				       "}\n";  
	   	    }   	    
	   	    
	        return $str;
	    }
    }    

  /**
   * Javascript validator for "isFileType" check
   * Perform the validation of "isFileType" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   string   $type     Type to check (,devide)
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isFileType($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
    	if($field!='' && $type!=''){  		
	   		$str = "\n\n //checks file type.\n";
	   		if(!empty($type)) $type = str_replace(',','|',$type);
	       	$str.= "var reg = new RegExp('(".$type.")');\n".
	       		   "if((fc['".$field."'].value!='') && (!reg.test(fc['".$field."'].value))){\n".
					"alert('$message');\n".
				    $focusStr."return false;\n".
				    "}\n";  	
	   	    
	        return $str;
	    }
    }



  /**
   * Javascript validator for "dateCompare" check
   * Perform the validation of "dateCompare" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $after_year  $after_month  $after_day  after date
   *						   string   $before_year $before_month $before_day before date
   *                           boolean  $dateEqual   if set TRUE,then if the "after_date" must be the  same as the "before_date"
   *                           boolean  $compToday if set TRUE,then it will ignore the "before_date" replace with TODAY
   * @return string JS function body
   **/ 	
   function js_validator_dateCompare($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if($after_year!='' && $after_month!='' && $after_day!='' && $before_year!='' && $before_month!='' && $before_day!='') {
	   		$str = "\n\n //compare two input dates.\n";
	       	$str.= "var date1 = fc['".$after_year."'].value+'/'+fc['".$after_month."'].value+'/'+fc['".$after_day."'].value;\n".
	       	       "var date2 = fc['".$before_year."'].value+'/'+fc['".$before_month."'].value+'/'+fc['".$before_day."'].value;\n".
	       	       "var d1 = new Date(date1);\n";
	       	//if "compToday" set TRUE,then it will ignore the "before_date" replace with TODAY       
	       	if($compToday!='') $str.= "var d2 = new Date();\n";
	       		else $str.= "var d2 = new Date(date2);\n";
	       	
	       	 $str.= "if(d1=='NaN' || d2=='NaN'){\n".
	       	 		 "alert('$message');\nreturn false;\n".
	       	 		 "}\n".
	       	        "var difference = d1.getTime() - d2.getTime();\n".
	       	        "var elapsedDays = difference/1000/60/60/24;\n";
	       	        
	       	//if "dateEqual" set TRUE,then if the "after_date" must be the  same as the "before_date"       
			if($dateEqual!='') $str.= "if(elapsedDays!=0){\n";
				else $str.= "if(elapsedDays<0){\n";
	       	             		  
			$str.= "alert('$message');\n".
					"return false;\n".
			        "}\n";  	
	   	    
	        return $str;
	    }
    }


  /**
   * Javascript validator for "isRestrict" check
   * Perform the validation of "isRestrict" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field     Field to test
   *						   string   $restrict  restrict letter 
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 	
   function js_validator_isRestrict($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if(strtolower($restrict)=='notab') $restrict = "\\t\\n\\r";
   		if(strtolower($restrict)=='specialchars') $restrict = "><,[]{}?/+=|\\\'\\\":;~!@#*$%^&()`";
   		if($field!='' && $restrict!=''){
   			$str = "\n //check restrict letter\n".
   			       "var badChar = \"".$restrict."\";\n".
	        	   "var i;\n".
	        	   "for (i = 0; i < fc['".$field."'].value.length; i++){\n".
	        	   "var c = fc['".$field."'].value.charAt(i);\n".
	        	   "if (badChar.indexOf(c)>=0) {\n".
	        	   "alert('$message');\n".
	   		       $focusStr."return false;\n".
	   		       "}\n}\n";
	        return $str;
	    }
    }	

  /**
   * Javascript validator for "isRegExp" check
   * Perform the validation of "isRegExp" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field       Field to test
   *						   string   $expression  regular expression
   *                           bool     $reverse     reverse operation 
   *                           bool     $focus       If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 	

  function js_validator_isRegExp($params){
   		extract($params);
   		$message = (empty($message))?sprintf($this->defaultErrMsg,$field):$message;
   		$focusStr = ($focus===false || $focus=='false' || $focus=='FALSE') ?'':'fc.'.$field.".focus();\n";
   		if($reverse!='') $reverse = true;
   		if($field!='' && $expression!=''){
   			$str = "\n//check the field by regex\n".
   			       "var myregexp = new RegExp(\"".$expression."\");\n".
   			       "var match = myregexp.exec(fc['".$field."'].value);\n";
   		
   			if($reverse) $str.="if(match==null){\n";
   				else  $str.="if(match!=null){\n";
	        	  
		    $str.= "alert('$message');\n".
	   		         $focusStr."return false;\n".
	   		         "}\n";
	   		       
	       return $str;
		}
   	}	    
 



}


?>
