<?
  /**
   * Javascript validator for "isFileSize" check
   * Perform the validation of "isFileSize" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   string   $min      minimum size 
   *                           string   $max      maximum size 
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		

   function js_validator_isFileSize(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = $formcat->addFocus($field,$focus);
   		if(!empty($field)){
	   		$title = "\n\n //checks file size.\n";
	   		$body = "var oas=new ActiveXObject(\"Scripting.FileSystemObject\");\n".
	   			    "var fname=fc['".$field."'].value;\n".
	   			    "var fh=oas.getFile(fname);\n".
	   			    "var fsize=fh.size/1024;\n"; 
	   			  			
	   		if(!empty($min)) $body.= ($optional)?"if(fsize>".$min." && !confirm('$message')){\n":"if(fsize>".$min."){\nalert('$message');\n";
	   		if(!empty($max)) $body.=($optional)?"if(fsize<".$max." && !confirm('$message')){\n":"if(fsize<".$max."){\nalert('$message');\n";
	   	    $str= $title.$body.$focusStr."return false;\n}\n";		
	        return $str;
	    }
    }    

?>