<?
  /**
   * Javascript validator for "isEqual" check
   * Perform the validation of "isEqual" check
 
   * @param array    $params   params set including following parameters:	
   *                           string   $field    Field to test
   *						   string   $field2   Field2 to test
   *                           string   $message  Error message used in place of the default one
   *                           bool     $focus    If error whether focus on the input element (optional)
   * @return string JS function body
   **/ 		
   function js_validator_isEqual(&$formcat,$params){
   		extract($params);
   		$message = (empty($message))?sprintf($formcat->defaultErrMsg,$field):$message;
   		$focusStr = $formcat->addFocus($field,$focus);
   		if($field!='' && $field2!=''){
	   		$title = "\n\n //checks if two fields are equal in value. field2 attribute required.\n";
	   		$body = ($optional)?"if((fc['".$field."'].value != fc['".$field2."'].value) && !confirm('$message')){\n":"if(fc['".$field."'].value != fc['".$field2."'].value){\nalert('$message');\n";
	   		         		       
	        $str= $title.$body.$focusStr."return false;\n}\n";		
	        return $str;
	    }
    }

?>